/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.main.CopyPasteUtil;
import com.tcs.efiling.form.main.MainController;
import com.tcs.efiling.form.main.YesNoController;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.input.Clipboard;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import netscape.javascript.JSObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableElement;
import org.w3c.dom.html.HTMLTableRowElement;

public class CopyPasteController
implements Initializable {
    static final com.tcs.efiling.form.config.Logger LOG = com.tcs.efiling.form.config.Logger.getLogger(CopyPasteController.class);
    private Stage myDialogStage;
    MainController mainController;
    @FXML
    WebView webview;
    WebEngine engine;
    Clipboard clipboard;
    String TABLE_NAME;
    String heads;
    String last;
    int panIndex;

    public void initialize(URL url, ResourceBundle rb) {
        LOG.info("initialize starts");
        this.engine = this.webview.getEngine();
        this.engine.setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

            public void handle(WebEvent<String> t) {
                LOG.info("alert: " + t);
            }
        });
        this.engine.load(FormConfigUtil.getExternalForm(FormConfigUtil.getActulaJarPath() + "/Config/CopyPaste.html"));
        this.engine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> ov, Worker.State t, Worker.State t1) {
                JSObject jSObject = (JSObject)CopyPasteController.this.engine.executeScript("window");
                jSObject.setMember("j", CopyPasteController.this);
            }
        });
        this.clipboard = Clipboard.getSystemClipboard();
        LOG.info("initialize ends");
    }

    public void showDialog() {
        this.myDialogStage.sizeToScene();
        this.myDialogStage.show();
    }

    public void hideDialog() {
        this.myDialogStage.hide();
    }

    @FXML
    public void importTable(String tableName, String heads, String last) {
        LOG.info("importTable starts with table name: " + tableName + ", heads: " + heads + ", last: " + last);
        this.TABLE_NAME = tableName;
        this.heads = heads;
        this.last = last;
        try {
            this.engine.executeScript("startNewTable()");
            HTMLTableElement tableElement = (HTMLTableElement)MainController.itrEngine.executeScript("document.getElementById('" + tableName + "')");
            HTMLCollection rows = tableElement.getRows();
            HTMLTableRowElement row = (HTMLTableRowElement)rows.item(0);
            HTMLCollection cells = row.getCells();
            for (int i = 0; i < cells.getLength(); ++i) {
                HTMLTableCellElement cell = (HTMLTableCellElement)cells.item(i);
                String columnName = cell.getTextContent().replaceAll("'", "");
                if (columnName.startsWith("PAN")) {
                    this.panIndex = i - 2;
                }
                if (columnName.trim().length() == 0) continue;
                this.engine.executeScript("addColumn('" + columnName + "')");
            }
            this.engine.executeScript("addDummyRows(500)");
            this.showDialog();
        }
        catch (Exception e) {
            LOG.error("Error ", e);
        }
    }

    public void copyData1(String row, String tempColumn, String totalRows) {
        LOG.info("copydata starts wiht values; " + row + " colurmn:" + tempColumn + " totalRows " + totalRows);
        int tempRowPosition = Integer.parseInt(row);
        int temoColumnPosition = Integer.parseInt(tempColumn);
        CopyPasteUtil cpUtil = new CopyPasteUtil();
        cpUtil.setRowPosition(tempRowPosition);
        cpUtil.setColPosition(temoColumnPosition);
        cpUtil.setTotalRows(Integer.parseInt(totalRows));
        cpUtil.setMainController(this.mainController);
        cpUtil.setClipboardData(this.clipboard.getHtml().toString());
        cpUtil.setPanIndex(this.panIndex);
        cpUtil.setButtonType("copyPaste");
        Thread cpUtilThread = new Thread((Runnable)((Object)cpUtil));
        cpUtilThread.start();
    }

    public void copyData(final String row, final String tempColumn, final String totalRows) {
        LOG.info("copydata starts wiht values; " + row + " colurmn:" + tempColumn);
        WebView browser = new WebView();
        final WebEngine webEngine = browser.getEngine();
        File outFile = null;
        if (this.clipboard.getHtml() != null) {
            outFile = this.convertTOFIle(this.clipboard.getHtml().toString());
            try {
                webEngine.load(outFile.toURI().toURL().toExternalForm());
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(CopyPasteController.class.getName()).log(Level.SEVERE, null, ex);
            }
            webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                public void changed(ObservableValue<? extends Worker.State> ov, Worker.State oldState, Worker.State newState) {
                    if (newState == Worker.State.SUCCEEDED) {
                        try {
                            int tempRowPosition = Integer.parseInt(row);
                            int temoColumnPosition = Integer.parseInt(tempColumn);
                            Document document = webEngine.getDocument();
                            NodeList nodeList = document.getElementsByTagName("TR");
                            int nodeLength = nodeList.getLength();
                            CopyPasteController.this.addColumn(totalRows, tempRowPosition, nodeLength);
                            for (int i = 0; i < nodeLength; ++i) {
                                Node cell = nodeList.item(i);
                                NodeList cellList = cell.getChildNodes();
                                int temp = 0;
                                for (int j = 0; j < cellList.getLength(); ++j) {
                                    Node node = cellList.item(j);
                                    if (node.getNodeType() != 1) continue;
                                    String data = node.getTextContent().replaceAll("\n", "");
                                    CopyPasteController.this.engine.executeScript("setCellValue('" + (tempRowPosition + i) + "','" + (++temp + temoColumnPosition) + "','" + data + "')");
                                }
                            }
                            LOG.info("document: " + nodeList.getLength());
                        }
                        catch (Exception e) {
                            LOG.error("error,", e);
                        }
                    }
                }
            });
        }
        if (outFile != null && outFile.exists()) {
            outFile.delete();
        }
    }

    @FXML
    public void saveData() {
        YesNoController yesNoController = this.mainController.generateYesNoDialog("Confirmation", 6, FormConfigUtil.getConfigProperty("itr.copypaste.save.confmsg"));
    }

    public void saveCPData() {
        try {
            JSObject jsObject = (JSObject)this.engine.executeScript("getNameVals();");
            int rowLength = (Integer)jsObject.getMember("length");
            ArrayList<ArrayList<String>> tableCellValuesScript = new ArrayList<ArrayList<String>>();
            int rowcount = (Integer)MainController.itrEngine.executeScript("addRowsForCopyPasteRowCount('" + this.TABLE_NAME + "','" + this.heads + "','" + this.last + "')");
            int nonEmptyRowCount = (Integer)MainController.itrEngine.executeScript("addRowsForCopyPasteNonEmptyRowCount('" + this.TABLE_NAME + "','" + this.heads + "','" + this.last + "')");
            CopyPasteController.addRowsForCopyPaste(this.mainController.getItrEngine(), rowLength, this.TABLE_NAME, this.heads, this.last, rowcount, nonEmptyRowCount);
            String script = "";
            String colValue = "";
            ArrayList<String> scripts = null;
            for (int i = 0; i < rowLength; ++i) {
                scripts = new ArrayList<String>();
                JSObject objj = (JSObject)jsObject.getSlot(i);
                int cellLength = (Integer)objj.getMember("length");
                for (int j = 0; j < cellLength; ++j) {
                    colValue = (String)objj.getSlot(j);
                    script = "setTableCellValues('" + this.TABLE_NAME + "','" + (nonEmptyRowCount + i) + "','" + (j + 2) + "','" + colValue + "')";
                    scripts.add(script);
                    script = null;
                    colValue = null;
                }
                tableCellValuesScript.add(scripts);
            }
            CopyPasteUtil cpUtil = new CopyPasteUtil();
            cpUtil.setMainController(this.mainController);
            cpUtil.setButtonType("saveCPData");
            cpUtil.setTableCellValuesScript(tableCellValuesScript);
            cpUtil.setCopyPasteController(this);
            Thread cpUtilThread = new Thread((Runnable)((Object)cpUtil));
            cpUtilThread.start();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void addRowsForCopyPaste(WebEngine itrEngine, int rowLength, String tableName, String heads, String last, int rowcount, int nonEmptyRowCount) {
        for (int i = 0; i < rowLength - (rowcount - nonEmptyRowCount); ++i) {
            itrEngine.executeScript("addRowToTableNoCheck('" + tableName + "','" + heads + "','" + last + "')").toString();
        }
    }

    public void importCSV() {
        File file = this.mainController.openFileDialog(false, ".csv", null);
        CopyPasteUtil cpUtil = new CopyPasteUtil();
        cpUtil.setButtonType("importCsv");
        cpUtil.setImportCsvFile(file);
        cpUtil.setMainController(this.mainController);
        Thread cpUtilThread = new Thread((Runnable)((Object)cpUtil));
        cpUtilThread.start();
    }

    public File convertTOFIle(String content) {
        File tempOutFile = null;
        try {
            String str1 = content.toUpperCase();
            String result = content.substring(str1.indexOf("<TR"), str1.lastIndexOf("</TR>"));
            tempOutFile = File.createTempFile("TempTXT", ".html");
            BufferedWriter out = new BufferedWriter(new FileWriter(tempOutFile));
            out.write("<TABLE>");
            out.write("<TBODY>");
            out.write(result);
            out.write("</TR></TBODY>");
            out.write("</TABLE>");
            out.close();
        }
        catch (Exception e) {
            LOG.error("error,", e);
        }
        return tempOutFile;
    }

    public void addColumn(String totalRows, int rowPosition, int nodeLength) {
        int totalRowsint = Integer.parseInt(totalRows);
        int emptyRows = totalRowsint - rowPosition;
        int addRows = nodeLength - emptyRows;
        if (addRows > 0) {
            this.mainController.copyPasteController.engine.executeScript("addDummyRows('" + addRows + "')");
        }
    }

    @FXML
    public void close() {
        YesNoController yesNoController = this.mainController.generateYesNoDialog("Confirmation", 7, FormConfigUtil.getConfigProperty("itr.copypaste.close.confmsg"));
        yesNoController.setCopyPasteController(this);
    }

    public Stage getMyDialogStage() {
        return this.myDialogStage;
    }

    public void setMyDialogStage(Stage myDialogStage) {
        this.myDialogStage = myDialogStage;
    }

    public MainController getMainController() {
        return this.mainController;
    }

    public void setMainController(MainController mainController) {
        this.mainController = mainController;
    }
}

