/*
 * Decompiled with CFR 0.152.
 */
package com.tcs.efiling.form.main;

import com.tcs.efiling.form.config.FormConfigUtil;
import com.tcs.efiling.form.config.Logger;
import com.tcs.efiling.form.main.AboutController;
import com.tcs.efiling.form.main.CopyPasteController;
import com.tcs.efiling.form.main.CreateHash;
import com.tcs.efiling.form.main.ErrorDialogController;
import com.tcs.efiling.form.main.ExitDialogController;
import com.tcs.efiling.form.main.FormCacher;
import com.tcs.efiling.form.main.FormUtil;
import com.tcs.efiling.form.main.HelpLayoutController;
import com.tcs.efiling.form.main.LoadingDialogController;
import com.tcs.efiling.form.main.MainLoader;
import com.tcs.efiling.form.main.NewFormDialog;
import com.tcs.efiling.form.main.PopUpController;
import com.tcs.efiling.form.main.PrefillFormDialogController;
import com.tcs.efiling.form.main.PreviewUtil;
import com.tcs.efiling.form.main.SaveFORMDialogController;
import com.tcs.efiling.form.main.SubmitFORMDialogController;
import com.tcs.efiling.form.main.SubmitFORMSuccessController;
import com.tcs.efiling.form.main.UpdateController;
import com.tcs.efiling.form.main.ValidationCacher;
import com.tcs.efiling.form.main.WebServiceUtilBulk;
import com.tcs.efiling.form.main.WebServiceUtilSingle;
import com.tcs.efiling.form.main.YesNoController;
import com.tcs.efiling.form.validation.main.FieldValidatorRoot;
import com.tcs.efiling.form.validation.main.Validator;
import com.tcs.efiling.form.validation.main.ValidatorInteface;
import com.tcs.efiling.plugins.JsPluginInterface;
import com.tcs.efiling.plugins.PluginRegistry;
import java.io.File;
import java.net.URL;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import netscape.javascript.JSObject;
import org.w3c.dom.Document;
import org.w3c.dom.html.HTMLAnchorElement;
import org.w3c.dom.html.HTMLDocument;
import org.xml.sax.SAXParseException;

public class MainController
implements Initializable {
    static final Logger LOG = Logger.getLogger(MainController.class);
    @FXML
    WebView itrView;
    public static WebEngine itrEngine;
    @FXML
    Button newFile;
    @FXML
    Button saveFile;
    @FXML
    Button importXml;
    @FXML
    Button saveAsDraft;
    @FXML
    Button generateXml;
    @FXML
    Button previous;
    @FXML
    Button next;
    @FXML
    Button prefill;
    @FXML
    Button preview;
    @FXML
    Button submitBulk;
    @FXML
    ScrollPane scrollPane;
    @FXML
    MenuItem menuNextPage;
    @FXML
    MenuItem menuPreviousPage;
    @FXML
    MenuItem menuImport;
    @FXML
    MenuItem menuSaveAll;
    @FXML
    MenuItem menuSave;
    @FXML
    MenuItem menuClearError;
    @FXML
    MenuItem menuGenerate;
    @FXML
    MenuItem menuUpdate;
    @FXML
    MenuItem hideShow;
    @FXML
    MenuItem menuSubmitBulk;
    @FXML
    MenuItem menuPrefill;
    @FXML
    Text openedFORM;
    @FXML
    HBox hboxMenu;
    @FXML
    WebView formErrView;
    public static WebEngine formErrEngine;
    @FXML
    ProgressBar vaidationBar;
    @FXML
    VBox errorVbox;
    @FXML
    HBox hboxItr;
    public static File generateXmlFile;
    File outputFileDraft;
    File outputFileSave;
    File outputFileImport;
    File outputFileSubmit;
    FormUtil itrUtil;
    Validator validator;
    JsPluginInterface plugins = new JsPluginInterface();
    static double windowWidth;
    public boolean generateXmlFlag;
    boolean validateSchemaFlag = false;
    LoadingDialogController loadingController;
    Stage parentStage;
    Thread updateThread;
    public boolean submitItrFlag = false;
    public static String itrName;
    public static String asstYear;
    public static String version;
    public static String isCaFlag;
    public static boolean anyError;
    WebServiceUtilSingle webServiceUtil = new WebServiceUtilSingle();
    WebServiceUtilBulk webServiceUtilBulk = new WebServiceUtilBulk();
    private static MainController instance;
    UpdateController updateController = null;
    PrefillFormDialogController controller;
    NewFormDialog prefillMyDialog = null;
    AboutController aboutController = null;
    static int loadWebserviceHome;
    PopUpController popUpController;
    CopyPasteController copyPasteController;
    String FORM_HOME_LINKS = "";
    static int loadHomePage;
    static int utility_opened;
    ChangeListener<Worker.State> homeListener;
    String htmlFileName = null;
    static boolean loadFlag;
    ErrorDialogController errorController;
    NewFormDialog errorMyDialog;
    boolean saveDraft = false;
    double vboxActWidth;
    double webViewActWidth;
    File importXmlFile;
    int loadFORMDone = 0;
    ToggleGroup group = null;
    private static final Map<String, String> TAB_NAME_VALUE;
    private static final Map<String, ToggleButton> SCROLL_BUTTON;
    private double totalScrollWidth = 0.0;
    File initDirectory = null;
    File tempFile;
    HelpLayoutController helpController;
    static long size;

    public MainController() {
        instance = this;
    }

    public static MainController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        long time1;
        block5: {
            LOG.debug("initialize starts");
            time1 = System.currentTimeMillis();
            FormConfigUtil.setMainController(this);
            this.itrView.setContextMenuEnabled(false);
            this.itrView.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent event) {
                    Dragboard db = event.getDragboard();
                    boolean success = false;
                    if (db.hasFiles()) {
                        success = true;
                        for (File file : db.getFiles()) {
                            MainController.this.startImport(file);
                            LOG.info("filePath" + file.getAbsolutePath());
                        }
                    }
                    event.setDropCompleted(success);
                    event.consume();
                }
            });
            this.itrView.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

                public void handle(DragEvent t) {
                    t.consume();
                }
            });
            this.formErrView.setContextMenuEnabled(false);
            itrEngine = this.itrView.getEngine();
            itrEngine.getHistory().setMaxSize(1);
            formErrEngine = this.formErrView.getEngine();
            if (FormConfigUtil.getConfigProperty("webservice.url").equals("https://incometaxindiaefiling.gov.in/e-FilingWS/ditws")) {
                try {
                    boolean isvalid = CreateHash.generateSignature();
                    LOG.info("Is utiltity valid ::" + isvalid);
                    if (!isvalid) {
                        anyError = true;
                        break block5;
                    }
                    this.loadHomePage();
                    this.loadToolBar();
                }
                catch (Exception e) {
                    LOG.error("Error in CreateHash: ", e);
                }
            } else {
                this.loadHomePage();
                this.loadToolBar();
            }
        }
        this.itrUtil = new FormUtil();
        FormUtil.mainController = this;
        this.changeButtonStatus(true);
        this.generateMsgDialogController();
        long time2 = System.currentTimeMillis();
        this.webServiceUtil.setMainController(this);
        LOG.debug("initialize ends: time taken: " + (time2 - time1));
    }

    public void checkErrors() {
        if (anyError) {
            this.generateErrorDialog(FormConfigUtil.getConfigProperty("msg.utility.invalid"), true);
        }
    }

    public void openLink(String url) {
        MainLoader.hostServices.showDocument(url);
    }

    public void generateSubmitFORMSuccess() {
        LOG.info("inside generateSubmitFORMSuccess");
        NewFormDialog myDialog = new NewFormDialog(null, true, "Submit FORM Success", "SubmitFORMSuccess.fxml");
        SubmitFORMSuccessController submitFORMSuccessController = (SubmitFORMSuccessController)myDialog.getController();
        submitFORMSuccessController.setMyDialogStage(myDialog);
        submitFORMSuccessController.setMainController(this);
        myDialog.sizeToScene();
        myDialog.show();
    }

    public Stage createUpdateController() {
        UpdateController.setMainController(this);
        NewFormDialog myDialog = new NewFormDialog(null, true, "Update Utility", "UpdateDialog.fxml");
        this.updateController = (UpdateController)myDialog.getController();
        this.updateController.setMyDialogStage(myDialog);
        myDialog.sizeToScene();
        return myDialog;
    }

    @FXML
    public void updateFORM() {
        if (this.updateController == null) {
            Stage myDialog = this.createUpdateController();
            myDialog.show();
        } else {
            this.updateController.openUpdateWindow();
        }
    }

    @FXML
    public void prefill() {
        try {
            MainLoader mainLoader = new MainLoader();
            Stage parent = mainLoader.getParentStage();
            if (this.controller == null) {
                this.prefillMyDialog = new NewFormDialog(parent, true, "Prefill FORM", "PrefillFORMDialog.fxml");
                this.controller = (PrefillFormDialogController)this.prefillMyDialog.getController();
                this.controller.setMyDialogStage(this.prefillMyDialog);
                this.controller.setMainController(this);
            }
            this.controller.getAsstYear().setText(asstYear);
            this.controller.getItr().setText(itrName);
            this.controller.setItrEngine(itrEngine);
            this.prefillMyDialog.sizeToScene();
            this.prefillMyDialog.show();
        }
        catch (Exception e) {
            LOG.error("Error in prefill: ", e);
            this.generateErrorDialog(e.getMessage(), true);
        }
    }

    public void loadToolBar() {
        try {
            Image nextImage = new Image(FormConfigUtil.getImage("toolbar/next.png"));
            Image previousImage = new Image(FormConfigUtil.getImage("toolbar/previous.png"));
            Image newFileImage = new Image(FormConfigUtil.getImage("toolbar/newFile.png"));
            Image saveFileImage = new Image(FormConfigUtil.getImage("toolbar/saveFile.png"));
            Image saveAllImage = new Image(FormConfigUtil.getImage("toolbar/saveAll.png"));
            Image importXmlImage = new Image(FormConfigUtil.getImage("toolbar/openFile.png"));
            Image prefillImage = new Image(FormConfigUtil.getImage("toolbar/prefill.png"));
            Image submitItrImage = new Image(FormConfigUtil.getImage("toolbar/submit.png"));
            Image calcualteItrImage = new Image(FormConfigUtil.getImage("toolbar/re_calculate.jpg"));
            Image submitBulkItrImage = new Image(FormConfigUtil.getImage("toolbar/submitBulk.jpg"));
            this.newFile.setGraphic((Node)new ImageView(newFileImage));
            this.importXml.setGraphic((Node)new ImageView(importXmlImage));
            this.saveFile.setGraphic((Node)new ImageView(saveAllImage));
            this.saveAsDraft.setGraphic((Node)new ImageView(saveFileImage));
            this.prefill.setGraphic((Node)new ImageView(prefillImage));
            this.generateXml.setGraphic((Node)new ImageView(submitItrImage));
            this.submitBulk.setGraphic((Node)new ImageView(submitBulkItrImage));
            this.previous.setGraphic((Node)new ImageView(previousImage));
            this.next.setGraphic((Node)new ImageView(nextImage));
            this.saveFile.disableProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                    if (!t1.booleanValue()) {
                        MainController.this.openedFORM.setText(itrName + "   " + asstYear);
                    } else {
                        MainController.this.openedFORM.setText("");
                    }
                }
            });
            this.importXml.disableProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                    if (t1.booleanValue()) {
                        MainController.this.menuImport.setDisable(true);
                    } else {
                        MainController.this.menuImport.setDisable(false);
                    }
                }
            });
            this.prefill.disableProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                    if (t1.booleanValue()) {
                        MainController.this.menuPrefill.setDisable(true);
                    } else {
                        MainController.this.menuPrefill.setDisable(false);
                    }
                }
            });
            this.generateXml.disableProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                    if (t1.booleanValue()) {
                        MainController.this.menuGenerate.setDisable(true);
                    } else {
                        MainController.this.menuGenerate.setDisable(false);
                    }
                }
            });
            this.submitBulk.disableProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                    if (t1.booleanValue()) {
                        MainController.this.menuSubmitBulk.setDisable(true);
                    } else {
                        MainController.this.menuSubmitBulk.setDisable(false);
                    }
                }
            });
            this.previous.disableProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                    if (t1.booleanValue()) {
                        MainController.this.menuPreviousPage.setDisable(true);
                    } else {
                        MainController.this.menuPreviousPage.setDisable(false);
                    }
                }
            });
            this.next.disableProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                    if (t1.booleanValue()) {
                        MainController.this.menuNextPage.setDisable(true);
                    } else {
                        MainController.this.menuNextPage.setDisable(false);
                    }
                }
            });
            this.saveFile.disableProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                    if (t1.booleanValue()) {
                        MainController.this.menuSave.setDisable(true);
                        MainController.this.menuSaveAll.setDisable(true);
                    } else {
                        MainController.this.menuSave.setDisable(false);
                        MainController.this.menuSaveAll.setDisable(false);
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error("Error in loadToolBar()", e);
        }
    }

    public void changeButtonStatus(boolean flag) {
        this.saveFile.setDisable(flag);
        this.generateXml.setDisable(flag);
        this.previous.setDisable(flag);
        this.next.setDisable(flag);
        this.prefill.setDisable(flag);
        this.saveAsDraft.setDisable(flag);
        this.generateXml.setDisable(flag);
    }

    private void hideButtonsBasedOnForm() {
        LOG.info("Inside hideButtonsBasedOnForm" + itrName);
        if (itrName.equalsIgnoreCase("FORM15CA")) {
            this.preview.setVisible(false);
            this.preview.setManaged(false);
            this.submitBulk.setVisible(true);
            this.submitBulk.setManaged(true);
            this.menuSubmitBulk.setDisable(false);
            this.prefill.setVisible(false);
            this.prefill.setManaged(false);
            this.menuPrefill.setDisable(true);
        } else if (itrName.equalsIgnoreCase("FORMBB")) {
            this.submitBulk.setVisible(false);
            this.submitBulk.setManaged(false);
            this.menuSubmitBulk.setDisable(true);
            this.menuSubmitBulk.setVisible(false);
            this.prefill.setVisible(true);
            this.prefill.setManaged(true);
            this.menuPrefill.setDisable(false);
        } else if (FormConfigUtil.isCaFlag(itrName, asstYear, isCaFlag)) {
            LOG.info("Inside disable" + itrName);
            this.generateXml.setVisible(false);
            this.generateXml.setManaged(false);
            this.menuGenerate.setDisable(true);
            this.menuGenerate.setVisible(false);
            this.submitBulk.setVisible(false);
            this.submitBulk.setManaged(false);
            this.preview.setVisible(true);
            this.preview.setManaged(true);
            this.menuSubmitBulk.setDisable(true);
            this.menuSubmitBulk.setVisible(false);
            this.prefill.setVisible(false);
            this.prefill.setManaged(false);
            this.menuPrefill.setDisable(true);
            this.menuPrefill.setVisible(false);
        } else if (itrName.equalsIgnoreCase("FORM6")) {
            this.generateXml.setVisible(false);
            this.generateXml.setManaged(false);
            this.menuGenerate.setDisable(true);
            this.menuGenerate.setVisible(false);
            this.submitBulk.setVisible(false);
            this.submitBulk.setManaged(false);
            this.preview.setVisible(true);
            this.preview.setManaged(true);
            this.menuSubmitBulk.setDisable(true);
            this.menuSubmitBulk.setVisible(false);
            this.prefill.setVisible(false);
            this.prefill.setManaged(false);
            this.menuPrefill.setDisable(true);
            this.menuPrefill.setVisible(false);
        } else {
            this.submitBulk.setVisible(false);
            this.submitBulk.setManaged(false);
            this.preview.setVisible(true);
            this.preview.setManaged(true);
            this.menuSubmitBulk.setDisable(true);
            this.menuSubmitBulk.setVisible(false);
            this.prefill.setVisible(false);
            this.prefill.setManaged(false);
            this.menuPrefill.setDisable(true);
            this.menuPrefill.setVisible(false);
        }
    }

    @FXML
    public void calculateFORM() {
        try {
            LOG.info("calculateFORM starts");
            this.addItrViewFocus();
            this.generateYesNoDialog("Calculate Tax", 1, null);
        }
        catch (Exception e) {
            LOG.error("Error in calculateFORM", e);
            this.generateErrorDialog(FormConfigUtil.getConfigProperty("error.itr.calculation"), false);
        }
    }

    @FXML
    public void about() {
        LOG.info("about stats");
        if (this.aboutController == null) {
            NewFormDialog myDialog = new NewFormDialog(null, true, "About FORM Utility", "About.fxml");
            this.aboutController = (AboutController)myDialog.getController();
            this.aboutController.setMyDialog(myDialog);
            this.aboutController.setAsstYear(asstYear);
            this.aboutController.setItr(FormConfigUtil.getFormName(itrName));
            if (FormConfigUtil.isCaFlag(itrName, asstYear, isCaFlag) || itrName.equalsIgnoreCase("FORM6") || itrName.equalsIgnoreCase("FORM64D") || itrName.equalsIgnoreCase("FORM64E")) {
                this.aboutController.asstYearHbox.setVisible(false);
                this.aboutController.asstYear.setVisible(false);
            }
            if (itrName.equalsIgnoreCase("FORM15CA")) {
                asstYear = "CY";
            }
            this.aboutController.setVersion(FormConfigUtil.getFormVersion(itrName + "_" + asstYear));
        }
        this.aboutController.showDialog();
        LOG.info("about ends");
    }

    @FXML
    public void submitBulk() {
        LOG.info("submitBulk starts");
        this.generateYesNoDialog("Open Submit Bulk Page", 3, FormConfigUtil.getConfigProperty("open.webservice.home"));
        LOG.info("submitBulk ends");
    }

    public void loadWebserviceHome() {
        LOG.info("loadWebserviceHome starts");
        this.hideValidation();
        this.changeButtonStatus(true);
        WebServiceUtilBulk.mainController = this;
        try {
            this.scrollPane.setVisible(false);
            loadWebserviceHome = 0;
            itrEngine.load(FormConfigUtil.getWebservicePage());
            itrEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                public void changed(ObservableValue<? extends Worker.State> ov, Worker.State t, Worker.State t1) {
                    if (t1.equals((Object)Worker.State.SUCCEEDED) && loadWebserviceHome == 0) {
                        LOG.info("inside loadWebserviceHome changed");
                        JSObject jsobj = (JSObject)itrEngine.executeScript("window");
                        jsobj.setMember("main", MainController.this);
                        jsobj.setMember("j", (Object)MainController.this.webServiceUtilBulk);
                        ++loadWebserviceHome;
                    }
                }
            });
            this.webServiceUtilBulk.setWebServiceEngine(itrEngine);
        }
        catch (Exception e) {
            LOG.error("Error in loadHomePage()", e);
        }
    }

    public void generateWebServiceErrorDialog(String error, boolean type, String fileName) {
        this.generateErrorDialog(error, type);
    }

    public YesNoController generateYesNoDialog(String title, int type, String errorTextYesNo) {
        YesNoController yesNo = null;
        try {
            LOG.info("calculateFORM starts");
            NewFormDialog myDialog = new NewFormDialog(null, true, title, "YesNoDialog.fxml");
            myDialog.sizeToScene();
            myDialog.show();
            yesNo = (YesNoController)myDialog.getController();
            yesNo.setMyDialogStage(myDialog);
            yesNo.setMainController(this);
            if (errorTextYesNo != null) {
                yesNo.setErrorText(errorTextYesNo);
            }
            yesNo.setType(type);
        }
        catch (Exception e) {
            LOG.error("Error in calculateFORM", e);
            this.generateErrorDialog(FormConfigUtil.getConfigProperty("error.itr.calculation"), false);
        }
        return yesNo;
    }

    public void generateMsgDialog(String msg, String javascript) {
        try {
            LOG.info("generateMsgDialog starts");
            this.popUpController.setJavascript(javascript);
            this.popUpController.showDialog(msg);
        }
        catch (Exception e) {
            LOG.error("Error in calculateFORM", e);
        }
    }

    public void startUpPopup() {
        NewFormDialog myDialog = new NewFormDialog(null, true, "IMPORTANT !!!", "PopUp.fxml");
        PopUpController popUpStartController = (PopUpController)myDialog.getController();
        popUpStartController.setMyDialogStage(myDialog);
        popUpStartController.setMainController(this);
        popUpStartController.setJavascript("");
        popUpStartController.decorate(StageStyle.DECORATED);
        popUpStartController.getMsgText().setFont(new Font(14.0));
        popUpStartController.showDialog(FormConfigUtil.getConfigProperty("itr.popup.msg"));
    }

    public void generateMsgDialogController() {
        try {
            LOG.info("calculateFORM starts");
            NewFormDialog myDialog = new NewFormDialog(null, true, "Message Dialogue", "PopUp.fxml");
            this.popUpController = (PopUpController)myDialog.getController();
            this.popUpController.setMyDialogStage(myDialog);
            this.popUpController.decorate(StageStyle.UNDECORATED);
            this.popUpController.setMainController(this);
            myDialog.removeEventHandler(KeyEvent.KEY_PRESSED, myDialog.getEventHandlerC());
        }
        catch (Exception e) {
            LOG.error("Error in calculateFORM", e);
            this.generateErrorDialog(FormConfigUtil.getConfigProperty("error.itr.calculation"), false);
        }
    }

    public void generateCopy() {
        try {
            LOG.info("generateCopy starts");
            if (this.copyPasteController == null) {
                NewFormDialog myDialog = new NewFormDialog(null, true, "", "CopyPaste.fxml");
                this.copyPasteController = (CopyPasteController)myDialog.getController();
                this.copyPasteController.setMyDialogStage(myDialog);
                this.copyPasteController.setMainController(this);
            }
        }
        catch (Exception e) {
            LOG.error("Error in generateCopy", e);
            this.generateErrorDialog(FormConfigUtil.getConfigProperty("error.itr.generateCopy"), false);
        }
    }

    @FXML
    public void preview() {
        LOG.info("preview called: for itr: " + itrName + " asstYear: " + asstYear);
        try {
            this.addItrViewFocus();
            long time1 = System.currentTimeMillis();
            HTMLDocument htmlDoc = (HTMLDocument)itrEngine.executeScript("document");
            File tempFile = FormConfigUtil.getHtmlTempFile(itrName, asstYear, version);
            FormUtil.writeHtmlToFile(tempFile, htmlDoc);
            Document newDoc = FormCacher.getDocument(tempFile);
            PreviewUtil.addToFieldNameValue(itrEngine);
            PreviewUtil.doc = newDoc;
            itrEngine.executeScript("beforePreview()");
            PreviewUtil.iterateNode(newDoc);
            PreviewUtil.addResources(itrName, asstYear, version);
            FormUtil.writeHtmlToFile(tempFile, newDoc);
            PreviewUtil.print(tempFile);
            long time2 = System.currentTimeMillis();
            this.generateErrorDialog(FormConfigUtil.getConfigProperty("msg.itr.preview"), false);
            LOG.debug("Temp Html File: " + tempFile.getAbsolutePath() + " Time taken: " + (time2 - time1));
        }
        catch (Exception e) {
            this.generateErrorDialog(FormConfigUtil.getConfigProperty("error.itr.preview"), true);
            LOG.error("Error in preview", e);
        }
    }

    public void loadEmptyFORMPage() {
        try {
            itrName = "";
            asstYear = "";
        }
        catch (Exception e) {
            LOG.error("Error in loadEmptyFORMPage()", e);
        }
    }

    public String getFORMHomeLinks() {
        LOG.debug("getFORMHomeLinks starts: ");
        if (this.FORM_HOME_LINKS.length() != 0) {
            return this.FORM_HOME_LINKS;
        }
        try {
            Map<String, Set<String>> maps = FormConfigUtil.ASSTYEAR_FORM;
            LOG.info("ASSTYEAR_FORM: " + maps);
            this.FORM_HOME_LINKS = maps.size() + "::";
            for (String key : maps.keySet()) {
                String itrs = "";
                Set<String> itr_ver = maps.get(key);
                for (String itr : itr_ver) {
                    itrs = itrs + itr + ",";
                }
                this.FORM_HOME_LINKS = this.FORM_HOME_LINKS + key + "," + itrs + "::";
            }
        }
        catch (Exception e) {
            LOG.error("Errror in getFORMHomeLinks()", e);
        }
        LOG.info("getFORMHomeLinks: " + this.FORM_HOME_LINKS);
        return this.FORM_HOME_LINKS;
    }

    public void loadHomePage() {
        try {
            this.openNewFORM(asstYear, itrName, version, null);
        }
        catch (Exception e) {
            LOG.error("Error in loadHomePage()", e);
        }
    }

    @FXML
    public void sbumitFORM() {
        LOG.debug("sbumitFORM starts");
        Validator.IS_SAVE = false;
        this.validateFORM();
        LOG.debug("sbumitFORM ends");
    }

    @FXML
    public void validateFORM() {
        LOG.debug("( starts");
        this.showValidation();
        this.vaidationBar.setProgress(0.0);
        itrEngine.executeScript("validateForm();");
    }

    @FXML
    public void submitFORM() {
        LOG.info("submit itr starts");
        try {
            SecureRandom secureRandom = new SecureRandom();
            this.submitItrFlag = true;
            this.generateXmlFlag = true;
            this.outputFileSubmit = File.createTempFile("FORM" + secureRandom.nextInt(), ".xml");
            this.generateXml(this.outputFileSubmit);
        }
        catch (Exception e) {
            this.generateErrorDialog(FormConfigUtil.getConfigProperty("error.itr.webservice"), true);
            LOG.error("Error in submitFORM", e);
        }
    }

    public void openNewFORM(String asstYear, String itrName, String ver, File importXml) {
        LOG.info("openNewFORM starts with values: asstYear:" + asstYear + ",itr:" + itrName + ",ver:" + ver + ",importXml:" + importXml);
        this.itrView.setVisible(false);
        long time1 = System.currentTimeMillis();
        boolean errorFlag = false;
        LOG.info("Opening FORM: " + itrName + " For AsstYear: " + asstYear);
        String htmlFile = FormConfigUtil.getHtmlFile(itrName, asstYear, ver);
        try {
            MainController.itrName = itrName;
            MainController.asstYear = asstYear;
            version = ver;
            if (importXml == null) {
                this.loadFORMView(htmlFile, null);
            } else {
                this.loadFORMView(htmlFile, importXml);
            }
        }
        catch (Exception e) {
            errorFlag = true;
            this.generateErrorDialog(FormConfigUtil.getConfigProperty("error.opening.itr"), true);
            LOG.error("Error in openNewFORM()", e);
        }
        if (!errorFlag) {
            if (loadFlag) {
                LOG.info("Xml imported is invalid");
            } else {
                this.loadingDialog();
            }
        } else {
            this.generateErrorDialog(FormConfigUtil.getConfigProperty("error.opening.itr"), true);
        }
        long time2 = System.currentTimeMillis();
        LOG.info("Time taken in openNewFORM(): " + (time2 - time1));
    }

    @FXML
    public void importXmlDialog() {
        LOG.info("importXmlDialog starts");
        boolean modified = (Boolean)itrEngine.executeScript("window.fileModifid");
        if (modified) {
            this.saveIfNot(4);
        } else {
            File file = this.openFileDialog(false, ".open", null);
            this.startImport(file);
        }
        LOG.info("importXmlDialog ends");
    }

    public void startImport(File file) {
        try {
            if (file != null) {
                FormCacher.initDoc(file.getAbsolutePath());
                String importItr = this.itrUtil.getFORMName();
                String importAsstYear = this.itrUtil.getAsstYear();
                if (importItr.equals("FORM15CA")) {
                    importAsstYear = "Current A.Y";
                } else if (importItr.equals("FORM6")) {
                    importAsstYear = "2015-16";
                } else if (importItr.equals("FORM3CB") || importItr.equals("FORM3CA")) {
                    importItr = importItr + "3CD";
                    importAsstYear = "2014-15";
                } else if (importItr.equals("FORM64A")) {
                    importAsstYear = "2015-16";
                } else if (importItr.equals("FORM64D")) {
                    importAsstYear = "2015-16";
                } else if (importItr.equals("FORM64E")) {
                    importAsstYear = "2017-18";
                } else if (importItr.equals("FORMBB")) {
                    importAsstYear = this.itrUtil.getAsstYear();
                } else if (!importItr.equals("FORM64A") || !importItr.equals("FORM64D") || !importItr.equals("FORM64E") && FormConfigUtil.isCaFlag(importItr, "2014-15", isCaFlag) || importItr.equals("FORM64")) {
                    importAsstYear = "2014-15";
                }
                LOG.info("startImport FOR FORM: " + importItr + ", asstYear: " + importAsstYear);
                if (itrName.equalsIgnoreCase(importItr) && asstYear.equalsIgnoreCase(importAsstYear)) {
                    this.openNewFORM(importAsstYear, importItr, version, file);
                } else {
                    this.generateErrorDialog(FormConfigUtil.getConfigProperty("error.invalid.asstyear.itr"), true);
                }
            }
        }
        catch (SAXParseException saxEx) {
            LOG.error("startImport error : ", saxEx);
            this.generateErrorDialog(FormConfigUtil.getConfigProperty("error.xml.import.invalid"), true);
        }
        catch (Exception e) {
            LOG.error("startImport error : ", e);
            this.generateErrorDialog(FormConfigUtil.getConfigProperty("error.invalid.asstyear.itr"), true);
        }
    }

    public void openDraft(String filePath) {
        LOG.debug("openDraft called");
        File file = new File(filePath);
        if (file.exists()) {
            try {
                FormCacher.initDoc(file.getAbsolutePath());
                String importItr = this.itrUtil.getFORMName();
                String importAsstYear = this.itrUtil.getAsstYear();
                itrName = importItr;
                asstYear = importAsstYear;
                this.openNewFORM(importAsstYear, importItr, version, file);
            }
            catch (Exception e) {
                this.generateErrorDialog(FormConfigUtil.getConfigProperty("itr.opening.draft.error"), true);
                LOG.error("openDraft error", e);
            }
        } else {
            LOG.warn("File does not exist.");
        }
    }

    @FXML
    public void newFile() {
        LOG.info("newFile starts");
        itrEngine.executeScript("clearTempFiles();");
        boolean modified = (Boolean)itrEngine.executeScript("window.fileModifid");
        if (modified) {
            this.saveIfNot(3);
        } else {
            this.loadHomePage();
        }
        LOG.info("newFile ends");
    }

    public void addItrViewFocus() {
        itrEngine.executeScript("setOnFocusDoc()");
    }

    public void loadingDialog() {
        MainLoader mainLoader = new MainLoader();
        Stage parent = mainLoader.getParentStage();
        String text = "Loading FORM";
        NewFormDialog myDialog = new NewFormDialog(parent, true, text, "Loading.fxml");
        myDialog.sizeToScene();
        myDialog.show();
        this.loadingController = (LoadingDialogController)myDialog.getController();
        this.loadingController.setMyDialogStage(myDialog);
        this.loadingController.setMainController(this);
    }

    public void generateErrorDialog(String error, boolean type) {
        String text = "Error";
        if (!type) {
            text = "Message";
        }
        if (this.errorController == null) {
            MainLoader mainLoader = new MainLoader();
            Stage parent = mainLoader.getParentStage();
            this.errorMyDialog = new NewFormDialog(parent, true, text, "ErrorDialog.fxml");
            this.errorController = (ErrorDialogController)this.errorMyDialog.getController();
            this.errorController.setMyDialogStage(this.errorMyDialog);
            this.errorMyDialog.sizeToScene();
        }
        if (type) {
            this.errorController.getErrorText().setTextFill((Paint)Color.RED);
        } else {
            this.errorController.getErrorText().setTextFill((Paint)Color.BLACK);
        }
        this.errorMyDialog.setTitle(text);
        this.errorController.getErrorText().setText(error);
        this.errorController.showDialog();
        this.errorMyDialog.sizeToScene();
    }

    @FXML
    public void saveFileAndValidate() {
        Validator.IS_SAVE = true;
        this.validateFORM();
    }

    @FXML
    public void saveFile() {
        this.generateXmlFlag = false;
        if (this.outputFileSave == null) {
            this.outputFileSave = this.openFileDialog(true, ".draft", null);
        } else if (!this.outputFileSave.exists()) {
            this.outputFileSave = null;
            this.outputFileSave = this.openFileDialog(true, ".draft", null);
        }
        if (this.outputFileSave != null) {
            this.saveDraft = true;
            this.generateXml(this.outputFileSave);
        }
    }

    public void generateXml(File outputFile) {
        long time1 = System.currentTimeMillis();
        String pan = (String)itrEngine.executeScript("getPan()");
        FormUtil iTRUtil = new FormUtil(itrName, asstYear, version);
        iTRUtil.setSchemaValidationFlag(this.validateSchemaFlag);
        iTRUtil.setMainController(this);
        iTRUtil.setPan(pan);
        iTRUtil.setAsstYear(asstYear);
        if (itrName.equalsIgnoreCase("FORM 3CB-3CD")) {
            itrName = "FORM3CB3CD";
        }
        if (itrName.equalsIgnoreCase("FORM 3CA-3CD")) {
            itrName = "FORM3CA3CD";
        }
        iTRUtil.setItrName(itrName);
        iTRUtil.setGenerateXmlFlag(this.generateXmlFlag);
        iTRUtil.setVer(version);
        iTRUtil.addToFieldNameValue(itrEngine);
        FormUtil.setOutputfilePath(outputFile.getAbsolutePath());
        Thread itrUtilTrhread = new Thread((Runnable)((Object)iTRUtil));
        itrUtilTrhread.start();
        long time2 = System.currentTimeMillis();
        LOG.info("Time taken to start generateXml(): " + (time2 - time1));
    }

    @FXML
    public void hideShowValidation() {
        LOG.info("hideShowValidation starts");
        if (this.webViewActWidth == 0.0) {
            this.webViewActWidth = windowWidth * 0.79;
            this.vboxActWidth = windowWidth * 0.17;
            LOG.info("webViewActWidth in: " + this.webViewActWidth + ",vboxActWidth:  " + this.vboxActWidth + ",mainController.windowWidth: " + windowWidth);
        }
        if (this.errorVbox.isVisible()) {
            this.hideValidation();
        } else {
            this.showValidation();
        }
        LOG.info("hideShowValidation ends");
    }

    public void hideValidation() {
        LOG.info("hide validation");
        this.errorVbox.setVisible(false);
        this.errorVbox.setPrefWidth(0.0);
        this.errorVbox.setMinWidth(0.0);
        this.itrView.setPrefWidth(windowWidth);
        this.hideShow.setText("Show Validation");
    }

    public void showValidation() {
        LOG.info("show validation");
        this.errorVbox.setVisible(true);
        this.errorVbox.setPrefWidth(this.vboxActWidth);
        this.itrView.setPrefWidth(this.webViewActWidth);
        this.hideShow.setText("Hide Validation");
    }

    public void goToNextPage() {
        boolean flag = (Boolean)itrEngine.executeScript("gotoNextPage()");
        if (!flag) {
            this.next.setDisable(true);
        }
        this.previous.setDisable(false);
    }

    @FXML
    public void prevPage() {
        int currentPage = Integer.parseInt((String)itrEngine.executeScript("document.getElementById('currentPage').value"));
        for (int i = currentPage - 1; i > 0; --i) {
            String pageCurr = "page" + i;
            ToggleButton button = SCROLL_BUTTON.get(pageCurr);
            this.gotoPrevPage();
            if (button == null || button.isVisible()) break;
        }
    }

    @FXML
    public void nextPage() {
        int currentPage = Integer.parseInt((String)itrEngine.executeScript("document.getElementById('currentPage').value"));
        int totalPage = Integer.parseInt((String)itrEngine.executeScript("document.getElementById('totalPage').value"));
        for (int i = currentPage + 1; i <= totalPage; ++i) {
            String pageCurr = "page" + i;
            ToggleButton button = SCROLL_BUTTON.get(pageCurr);
            boolean isNextAvail = false;
            for (int j = i; j <= totalPage; ++j) {
                pageCurr = "page" + j;
                if (!SCROLL_BUTTON.get(pageCurr).isVisible()) continue;
                isNextAvail = true;
                break;
            }
            if (isNextAvail) {
                this.goToNextPage();
            }
            if (button == null || button.isVisible()) break;
        }
    }

    public void IsnextPage() {
        boolean flag = (Boolean)itrEngine.executeScript("isNextPageExists()");
        if (!flag) {
            this.next.setDisable(true);
        } else {
            this.next.setDisable(false);
        }
    }

    public void IsprevPage() {
        try {
            boolean flag = (Boolean)itrEngine.executeScript("isPrevPageExists()");
            if (!flag) {
                this.previous.setDisable(true);
            } else {
                this.previous.setDisable(false);
            }
        }
        catch (Exception e) {
            LOG.info("Exception in IsprevPage ::" + e);
        }
    }

    public void gotoPrevPage() {
        boolean flag = (Boolean)itrEngine.executeScript("gotoPrevPage()");
        if (!flag) {
            this.previous.setDisable(true);
        }
        this.next.setDisable(false);
    }

    public void disableLoadButtons() {
        this.preview.setDisable(true);
    }

    public void enableLoadButtons() {
        this.preview.setDisable(false);
    }

    public void toggleTab(String page, boolean flag) {
        ToggleButton button = SCROLL_BUTTON.get(page);
        button.setVisible(flag);
        this.scrollPane.autosize();
        LOG.info("button text: " + button.getText() + "toggleTab called: for " + page + " flag: " + flag);
    }

    public void loadFORMView(String htmlPath, File importFile) {
        long time1 = System.currentTimeMillis();
        this.hideButtonsBasedOnForm();
        this.outputFileSave = null;
        this.scrollPane.setVisible(true);
        this.generateCopy();
        this.hideShowValidation();
        this.importXmlFile = importFile;
        this.loadFORMDone = 0;
        LOG.info("loading itr view: : " + itrName + " " + asstYear);
        if (htmlPath == null) {
            // empty if block
        }
        itrEngine.load(htmlPath);
        LOG.info("loading itr view: : " + htmlPath + " " + itrEngine.getDocument());
        itrEngine.setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

            public void handle(WebEvent<String> t) {
                LOG.info("itrEngine alert: " + t);
            }
        });
        itrEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> ov, Worker.State t, Worker.State t1) {
                LOG.debug("State change of FORM Form: old:" + t + ",new:" + t1);
                try {
                    if (t1.equals((Object)Worker.State.SUCCEEDED) && MainController.this.loadFORMDone == 0) {
                        long time1 = System.currentTimeMillis();
                        if (itrName.length() == 0) {
                            return;
                        }
                        JSObject jsobj = (JSObject)itrEngine.executeScript("window");
                        FormCacher.initDoc(FormConfigUtil.getSampleXmlFile(itrName, asstYear, version));
                        MainController.this.validator = new Validator();
                        MainController.this.itrUtil.setValidator(MainController.this.validator);
                        ValidationCacher.loadDoc(itrName, asstYear, version);
                        MainController.this.validator.setMainController(MainController.this);
                        PluginRegistry.init();
                        jsobj.setMember("p", MainController.this.plugins);
                        jsobj.setMember("j", (Object)MainController.this.validator);
                        jsobj.setMember("ju", (Object)MainController.this.itrUtil);
                        jsobj.setMember("main", MainController.this);
                        jsobj.setMember("cp", MainController.this.copyPasteController);
                        MainController.this.changeButtonStatus(false);
                        MainController.this.loadErrorView();
                        if (MainController.this.importXmlFile != null) {
                            FormUtil.initImportDoc(MainController.this.importXmlFile.getAbsolutePath());
                            itrEngine.executeScript("clearTempFiles();");
                            itrEngine.executeScript("beforeImport();");
                            MainController.this.itrUtil.importXml(itrEngine, MainController.this.importXmlFile.getAbsolutePath());
                            MainController.this.generateErrorDialog(FormConfigUtil.getConfigProperty("msg.import.success"), false);
                        }
                        MainController.this.addToTabMenu(itrEngine.executeScript("getAllTabs();"));
                        itrEngine.executeScript("loadFn()");
                        ++MainController.this.loadFORMDone;
                        MainController.this.loadingController.cancelDialog();
                        if (asstYear.equals("Current A.Y")) {
                            MainController.this.openedFORM.setText(FormConfigUtil.getFormName(itrName));
                        } else {
                            MainController.this.openedFORM.setText(FormConfigUtil.getFormName(itrName) + "   AY " + asstYear);
                            if (itrName.equalsIgnoreCase("FORM3CB3CD")) {
                                MainController.this.openedFORM.setText("FORM 3CB-3CD");
                            }
                            if (itrName.equalsIgnoreCase("FORM3CA3CD")) {
                                MainController.this.openedFORM.setText("FORM 3CA-3CD");
                            }
                            if (FormConfigUtil.isCaFlag(itrName, asstYear, isCaFlag) || itrName.equalsIgnoreCase("FORM64") || itrName.equalsIgnoreCase("FORM64A") || itrName.equalsIgnoreCase("FORM64D") || itrName.equalsIgnoreCase("FORM6") || itrName.equalsIgnoreCase("FORM64E")) {
                                MainController.this.openedFORM.setText(itrName);
                            }
                        }
                        long time2 = System.currentTimeMillis();
                        MainController.this.disableLoadButtons();
                        if (MainController.this.importXmlFile != null) {
                            MainController.this.enableLoadButtons();
                        }
                        MainController.this.itrView.setVisible(true);
                        if (!loadFlag) {
                            MainController.this.startUpPopup();
                        }
                        MainController.this.changeButtonStatus(false);
                        LOG.info("time taken in changed : " + (time2 - time1));
                    }
                }
                catch (Exception e) {
                    loadFlag = true;
                    MainController.this.loadHomePage();
                    LOG.error("error in changed: ", e);
                    MainController.this.generateErrorDialog(FormConfigUtil.getConfigProperty("itr.loading.error"), true);
                }
            }
        });
    }

    @FXML
    public void OpenSubmitDialog() {
        SubmitFORMDialogController.setMainController(this);
        NewFormDialog myDialog = FormConfigUtil.isCaFlag(itrName, asstYear, isCaFlag) ? new NewFormDialog(null, true, "Submit FORM", "SubmitFORM_CA.fxml") : new NewFormDialog(null, true, "Submit FORM", "SubmitFORM.fxml");
        myDialog.sizeToScene();
        myDialog.show();
        SubmitFORMDialogController submitcontroller = (SubmitFORMDialogController)myDialog.getController();
        if (itrName.equals("FORM64") || itrName.equals("FORM64A") || itrName.equals("FORM64D") || itrName.equals("FORM64E")) {
            FormUtil formutil = new FormUtil();
            String xmlAssYear = formutil.getAsstYear();
            submitcontroller.asstYear.setText(xmlAssYear);
            submitcontroller.setAsstYearVar(xmlAssYear);
        }
        submitcontroller.setMyDialogStage(myDialog);
    }

    public void addToTabMenu(Object obj) {
        this.totalScrollWidth = 0.0;
        TAB_NAME_VALUE.clear();
        this.scrollPane.setHvalue(0.0);
        JSObject jSObject = (JSObject)obj;
        int length = (Integer)jSObject.getMember("length");
        ObservableList list = this.hboxMenu.getChildren();
        this.hboxMenu.getChildren().clear();
        EventHandler<ActionEvent> enEventHandler = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                String text = ((ToggleButton)t.getSource()).getText();
                String action = (String)TAB_NAME_VALUE.get(text);
                itrEngine.executeScript(action);
            }
        };
        this.group = new ToggleGroup();
        for (int i = 0; i < length; ++i) {
            JSObject aTag = (JSObject)jSObject.getSlot(i);
            HTMLAnchorElement anchor = (HTMLAnchorElement)((Object)aTag);
            String name = anchor.getTextContent().replaceAll("\n", "").replaceAll("[\\s]+", " ");
            String onClick = anchor.getAttribute("onclick");
            ToggleButton button = new ToggleButton(name);
            button.setToggleGroup(this.group);
            button.setMinWidth(90.0);
            button.setOnAction((EventHandler)enEventHandler);
            if (i == 0) {
                button.setSelected(true);
            }
            TAB_NAME_VALUE.put(name, onClick);
            list.add((Object)button);
            SCROLL_BUTTON.put(onClick.substring(onClick.indexOf("'") + 1, onClick.lastIndexOf("'")), button);
        }
        LOG.info("SCROLL_BUTTON: " + SCROLL_BUTTON);
    }

    public void scrollToTab(String page) {
        if (this.totalScrollWidth == 0.0) {
            this.totalScrollWidth = SCROLL_BUTTON.get("page" + SCROLL_BUTTON.size()).layoutXProperty().get();
        }
        ToggleButton button = SCROLL_BUTTON.get(page);
        button.setSelected(true);
        this.scrollPane.setHvalue(button.layoutXProperty().get() / this.totalScrollWidth);
    }

    public SaveFORMDialogController saveIfNot(int type) {
        LOG.info("saveIfNot starts: type: " + type);
        MainLoader mainLoader = new MainLoader();
        Stage parent = mainLoader.getParentStage();
        NewFormDialog myDialog = new NewFormDialog(parent, true, "Save Form", "SaveFORMDialog.fxml");
        myDialog.sizeToScene();
        SaveFORMDialogController controller = (SaveFORMDialogController)myDialog.getController();
        controller.setMyDialogStage(myDialog);
        controller.setMainController(this);
        controller.setType(type);
        myDialog.show();
        LOG.info("saveIfNot after shows: ");
        return controller;
    }

    @FXML
    public void clearValidationError() {
        formErrEngine.executeScript("clearError();");
    }

    public void loadErrorView() {
        try {
            formErrEngine = this.formErrView.getEngine();
            formErrEngine.setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

                public void handle(WebEvent<String> t) {
                    LOG.info("formErrEngine alert: " + t);
                }
            });
            formErrEngine.load(FormConfigUtil.getErrPage());
            formErrEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                public void changed(ObservableValue<? extends Worker.State> ov, Worker.State t, Worker.State t1) {
                    if (t1.equals((Object)Worker.State.SUCCEEDED)) {
                        JSObject jsobj = (JSObject)formErrEngine.executeScript("window");
                        jsobj.setMember("j", MainController.this);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void focusField(String name) {
        itrEngine.executeScript("focusTabJava('" + name + "')");
    }

    public String getResourceURL(String path) {
        return this.getClass().getResource(path).toExternalForm();
    }

    @FXML
    public void closeUtility() {
        MainController.closeUtility(this.parentStage);
    }

    public File openFileDialog(boolean type, String extension, String title) {
        String[] ext;
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = null;
        for (String exten : ext = extension.split(",")) {
            if (exten.toUpperCase().indexOf("DRAFT") != -1) {
                extFilter = new FileChooser.ExtensionFilter("DRAFT File (" + exten + ")", new String[]{"*" + exten});
            } else if (exten.toUpperCase().indexOf("PFX") != -1 || exten.toUpperCase().indexOf("P12") != -1) {
                extFilter = new FileChooser.ExtensionFilter(".PFX/.P12 File (" + exten + ")", new String[]{"*" + exten});
            } else if (exten.toUpperCase().indexOf("ZIP") != -1) {
                extFilter = new FileChooser.ExtensionFilter("ZIP File (" + exten + ")", new String[]{"*" + exten});
            } else if (exten.toUpperCase().indexOf("PDF") != -1) {
                extFilter = new FileChooser.ExtensionFilter("PDF File (" + exten + ")", new String[]{"*" + exten});
            } else if (exten.toUpperCase().indexOf("EXE") != -1) {
                extFilter = new FileChooser.ExtensionFilter("EXE File (" + exten + ")", new String[]{"*" + exten});
            } else if (exten.toUpperCase().indexOf("CSV") != -1) {
                extFilter = new FileChooser.ExtensionFilter("CSV File (" + exten + ")", new String[]{"*" + exten});
            } else if (exten.toUpperCase().indexOf("XML") != -1) {
                extFilter = new FileChooser.ExtensionFilter("XML File (*.xml)", new String[]{"*.xml"});
            } else if (exten.toUpperCase().indexOf("OPEN") != -1) {
                extFilter = new FileChooser.ExtensionFilter("XML File (*.xml,*.draft)", new String[]{"*.xml", "*.draft"});
            }
            fileChooser.getExtensionFilters().add((Object)extFilter);
        }
        fileChooser.setInitialDirectory(this.initDirectory);
        if (type) {
            fileChooser.setTitle("Save FORM(XML) File.");
        } else if (extension.toUpperCase().indexOf("PFX") != -1) {
            fileChooser.setTitle("Open .PFX/.P12 File.");
        } else if (extension.toUpperCase().indexOf("CSV") != -1) {
            fileChooser.setTitle("Open .CSV File.");
        } else {
            fileChooser.setTitle("Open FORM(XML) File.");
        }
        if (title != null) {
            fileChooser.setTitle(title);
        }
        if (type) {
            String file;
            this.tempFile = fileChooser.showSaveDialog(null);
            if (this.tempFile != null && !(file = this.tempFile.getAbsolutePath()).toUpperCase().endsWith(extension.toUpperCase())) {
                this.tempFile = new File(file + extension);
            }
        } else {
            this.tempFile = fileChooser.showOpenDialog(null);
        }
        if (this.tempFile != null && this.tempFile.getParentFile().isDirectory()) {
            this.initDirectory = this.tempFile.getParentFile();
        }
        return this.tempFile;
    }

    @FXML
    public void openHelp() {
        if (this.helpController == null) {
            MainLoader mainLoader = new MainLoader();
            Stage parent = mainLoader.getParentStage();
            NewFormDialog myDialog = new NewFormDialog(parent, false, "Help", "HelpLayout.fxml");
            Rectangle2D rectangle2D = Screen.getPrimary().getVisualBounds();
            double height = rectangle2D.getHeight();
            double width = rectangle2D.getWidth();
            myDialog.setHeight(height);
            myDialog.setWidth(width / 2.0);
            this.helpController = (HelpLayoutController)myDialog.getController();
            this.helpController.setMyDialogStage(myDialog);
            this.helpController.setMainController(this);
        }
        this.helpController.show();
    }

    public void browseAttachment(String fieldName, String extension) {
        long size = 0L;
        LOG.info("inside browseAttachment");
        File file = this.openFileDialog(false, extension, "Open Attachment");
        WebServiceUtilSingle.ALL_ATTACHMENTS.put(fieldName, file);
        if (file != null) {
            size += file.length();
        } else {
            LOG.info("setfieldName empty");
            itrEngine.executeScript("setFileName('" + fieldName + "','');");
            return;
        }
        itrEngine.executeScript("setFileName('" + fieldName + "','" + file.getName() + "');");
        List<FieldValidatorRoot> fieldValidators = ValidationCacher.VALIDATION_MAP.get(fieldName);
        try {
            for (FieldValidatorRoot root : fieldValidators) {
                boolean isError = false;
                ValidatorInteface validator = root.getValidator();
                LOG.info("root.getValidator():" + root.getValidator());
                validator.resetHasErrors();
                validator.validate(file.getAbsolutePath(), fieldName, null);
                isError = validator.hasErrors();
                if (!isError) continue;
                LOG.info("insode fieldName empty isError" + isError);
                itrEngine.executeScript("setFileName('" + fieldName + "','');");
                return;
            }
            LOG.info("Total File size of uploaded attachment:" + size);
            if (size > 0x3200000L) {
                LOG.info("Inside size greater than 50MB");
                itrEngine.executeScript("addErrorXHTML('','Total size of uploaded files cannot be more than 50 MB');");
                itrEngine.executeScript("setFileName('" + fieldName + "','');");
                return;
            }
            LOG.info("size of file:" + size);
        }
        catch (Exception e) {
            LOG.error("blur error", e);
            LOG.warn("blur error for: type:  name: " + fieldName);
        }
        LOG.info("KEY while adding to ALL_ATTACHMENTS" + fieldName);
        LOG.info("in browseAttachment: " + WebServiceUtilSingle.ALL_ATTACHMENTS);
    }

    public String getItrName() {
        return itrName;
    }

    public void setItrName(String itrName) {
        MainController.itrName = itrName;
    }

    public static String getIsCaFlag() {
        return isCaFlag;
    }

    public static void setIsCaFlag(String isCaFlag) {
        MainController.isCaFlag = isCaFlag;
    }

    public String getAsstYear() {
        return asstYear;
    }

    public void setAsstYear(String asstYear) {
        MainController.asstYear = asstYear;
    }

    public WebView getFormErrView() {
        return this.formErrView;
    }

    public void setFormErrView(WebView formErrView) {
        this.formErrView = formErrView;
    }

    public WebEngine getFormErrEngine() {
        return formErrEngine;
    }

    public void setFormErrEngine(WebEngine formErrEngine) {
        MainController.formErrEngine = formErrEngine;
    }

    public FormUtil getItrUtil() {
        return this.itrUtil;
    }

    public void setItrUtil(FormUtil itrUtil) {
        this.itrUtil = itrUtil;
    }

    public WebEngine getItrEngine() {
        return itrEngine;
    }

    public void setItrEngine(WebEngine itrEngine) {
        MainController.itrEngine = itrEngine;
    }

    public ProgressBar getVaidationBar() {
        return this.vaidationBar;
    }

    public void setVaidationBar(ProgressBar vaidationBar) {
        this.vaidationBar = vaidationBar;
    }

    public Button getGenerateXml() {
        return this.generateXml;
    }

    public boolean isValidateSchemaFlag() {
        return this.validateSchemaFlag;
    }

    public void setValidateSchemaFlag(boolean validateSchemaFlag) {
        this.validateSchemaFlag = validateSchemaFlag;
    }

    public boolean getGenerateXmlFlag() {
        return this.generateXml.isDisable();
    }

    public static void closeUtility(Stage parentStage) {
        NewFormDialog myDialog = new NewFormDialog(parentStage, true, "Confirm Exit", "ExitDialog.fxml");
        myDialog.sizeToScene();
        myDialog.show();
        ExitDialogController exitDialogController = (ExitDialogController)myDialog.getController();
        exitDialogController.setMyDialogStage(myDialog);
    }

    public void setStage(Stage stage) {
        this.parentStage = stage;
    }

    public static String getVersion() {
        return version;
    }

    public static void setVersion(String version) {
        MainController.version = version;
    }

    public void saveCPData() {
        this.copyPasteController.saveCPData();
    }

    public Button getPreviewButton() {
        return this.preview;
    }

    static {
        itrName = "FORM10B";
        asstYear = "2014-15";
        version = "1.0";
        isCaFlag = "Y";
        anyError = false;
        instance = null;
        loadFlag = false;
        TAB_NAME_VALUE = new HashMap<String, String>();
        SCROLL_BUTTON = new LinkedHashMap<String, ToggleButton>();
        size = 0L;
    }
}

